#include <bits/stdc++.h>

using namespace std;

const int N = 42, inf = 1e9;
int LEFT, RIGHT;

struct segment {
	int l;
	int r;
	segment() { l = -inf; r = inf; }
	segment(int _l, int _r) { l = _l; r = _r; }
	void intersect_with(segment seg) { l = max(l, seg.l); r = min(r, seg.r); }
	segment operator / (int x) {
		if(x == 0) {
			if(l <= 0 && 0 <= r) return segment(-inf, inf);
			return segment(inf, -inf);
		}
		int nwl = l, nwr = r, absx = abs(x);
		if(nwl >= 0) nwl = (nwl + absx - 1) / absx;
		else nwl = nwl / absx;
		if(nwr >= 0) nwr = nwr / absx;
		else nwr = (nwr - absx + 1) / absx;
		if(x < 0) {
			nwl = -nwl;
			nwr = -nwr;
			swap(nwl, nwr);
		}
		return segment(nwl, nwr);
	}
	segment operator - (int x) { return segment(l - x, r - x); }
	bool valid() { return l <= r; }
};

int n;
long long s;
int m[N], a[N], l[N], r[N];
vector<int> have;
vector<segment> need;
vector<int> masks;

void calc_have(int i, long long h) {
	if(i == LEFT) {
		have.push_back(h);
		return;
	}
	if(l[i] <= h * m[i] && h * m[i] <= r[i]) calc_have(i + 1, h * m[i]);
	if(l[i] <= h + a[i] && h + a[i] <= r[i]) calc_have(i + 1, h + a[i]);
}

void calc_need(int i, segment seg, int mask) {
	if(i == n - 1 - RIGHT) {
		need.push_back(seg);
		masks.push_back(mask);
		return;
	}
	seg.intersect_with(segment(l[i], r[i]));
	if((seg / m[i]).valid()) calc_need(i - 1, seg / m[i], 2 * mask);
	if((seg - a[i]).valid()) calc_need(i - 1, seg - a[i], 2 * mask + 1);
}

long long check(long long h, int mask, int i) {
	// cout << h << "\n";
	for(int bit = 0; bit < RIGHT; bit++) {
		if((1 << bit) & mask) h += a[i];
		else {
			h *= m[i];
			if(h == -1e18) cout << i << " " << mask << "\n";
		}
		i++;
		// cout << h << "\n";
	}
	// cout << "\n";
	return h;
}

void solve() {
	cin >> n >> s;
	for(int i = 0; i < n; i++) cin >> m[i];
	for(int i = 0; i < n; i++) cin >> a[i];
	for(int i = 0; i < n; i++) cin >> l[i];
	for(int i = 0; i < n; i++) cin >> r[i];
	// LEFT = n, RIGHT = 0;
	LEFT = (n + 1) / 2, RIGHT = n / 2;
	have.clear();
	need.clear();
	masks.clear();
	calc_have(0, s);
	calc_need(n - 1, segment(), 0);
	sort(have.begin(), have.end());
	// for(int i : have) cout << i << " ";
	// cout << "\n";
	// for(segment seg : need) cout << seg.l << " " << seg.r << "\n";
	long long ans = -1e18;
	for(int i = 0; i < need.size(); i++) {
		// if(masks[i]&i^1) cout << need[i].l << " " << need[i].r << "OVDE\n\n";
		int L = lower_bound(have.begin(), have.end(), need[i].l) - have.begin();
		int R = upper_bound(have.begin(), have.end(), need[i].r) - have.begin() - 1;
		if(L >= 0 && L < have.size() && have[L] <= need[i].r) ans = max(ans, check(have[L], masks[i], LEFT));
		if(R >= 0 && R < have.size() && have[R] >= need[i].l && R != L) ans = max(ans, check(have[R], masks[i], LEFT));
	}
	if(ans == -1e18) cout << "nemoguce\n";
	else cout << ans << "\n";
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    int t;
    cin >> t;
    while(t--) solve();
    return 0;
}